/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments.region;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class RegionArgumentType
implements ArgumentType<String> {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z]+[A-Za-z\\d\\-]+[A-Za-z\\d]+$");
    private static final Collection<String> EXAMPLES = Stream.of("spawn", "arena4pvp", "shop", "nether-hub").collect(Collectors.toSet());
    private static final SimpleCommandExceptionType ERROR_AREA_INVALID = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"cli.arg.region.parse.invalid", (String)"Unable to parse region name!"));
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(flag -> class_2561.method_48322((String)"cli.arg.region.invalid", (String)"Region '%s' does not exist", (Object[])new Object[]{flag}));
    private static final DynamicCommandExceptionType ERROR_INVALID_LEVEL = new DynamicCommandExceptionType(flag -> class_2561.method_48322((String)"cli.arg.region.invalid", (String)"Unable to find dimension data", (Object[])new Object[]{flag}));

    public static <S> RegionType getRegionType(CommandContext<S> context) {
        String baseCmd;
        List nodes = context.getNodes();
        if (nodes.size() >= 2 && (baseCmd = ((ParsedCommandNode)nodes.get(0)).getNode().getName()).equals("yawp")) {
            boolean isFlagSubCmd;
            String regionTypeLiteral = ((ParsedCommandNode)nodes.get(1)).getNode().getName();
            RegionType regionType = RegionType.of(regionTypeLiteral);
            boolean bl = isFlagSubCmd = regionTypeLiteral.equals(CommandConstants.FLAG.toString()) && nodes.size() >= 3;
            if (isFlagSubCmd && regionType == null) {
                String flagRegionTypeLiteral = ((ParsedCommandNode)nodes.get(2)).getNode().getName();
                return RegionType.of(flagRegionTypeLiteral);
            }
            if (!isFlagSubCmd && regionType != null) {
                return regionType;
            }
        }
        return null;
    }

    public static IMarkableRegion getRegionIn(CommandContext<class_2168> context, String argName, class_1937 level) throws CommandSyntaxException {
        String regionName = (String)context.getArgument(argName, String.class);
        Optional<DimensionRegionCache> dimensionCache = RegionManager.get().getDimensionCache((class_5321<class_1937>)level.method_27983());
        if (dimensionCache.isPresent()) {
            DimensionRegionCache dimCache = dimensionCache.get();
            if (!dimCache.contains(regionName)) {
                MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_43470((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
                throw ERROR_INVALID_VALUE.create((Object)regionName);
            }
            IMarkableRegion region = dimCache.getRegion(regionName);
            if (region != null) {
                return region;
            }
            MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_43470((String)("No regions defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
            throw ERROR_INVALID_VALUE.create((Object)regionName);
        }
        throw ERROR_INVALID_LEVEL.create((Object)level.method_27983().method_29177().toString());
    }

    public static IMarkableRegion getRegion(CommandContext<class_2168> context, String argName) throws CommandSyntaxException {
        String regionName = (String)context.getArgument(argName, String.class);
        DimensionRegionCache dimCache = ArgumentUtil.getDimCacheArgument(context);
        if (!dimCache.contains(regionName)) {
            MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_43470((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
            throw ERROR_INVALID_VALUE.create((Object)regionName);
        }
        IMarkableRegion region = dimCache.getRegion(regionName);
        if (region != null) {
            return region;
        }
        MessageSender.sendCmdFeedback((class_2168)context.getSource(), class_2561.method_43470((String)("No regions defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
        throw ERROR_INVALID_VALUE.create((Object)regionName);
    }

    public static IProtectedRegion getRegion(CommandContext<class_2168> ctx, RegionType regionType) throws CommandSyntaxException {
        switch (regionType) {
            case GLOBAL: {
                return RegionDataManager.get().getGlobalRegion();
            }
            case DIMENSION: {
                DimensionRegionCache dimCache = ArgumentUtil.getDimCacheArgument(ctx);
                return dimCache.getDimensionalRegion();
            }
            case LOCAL: {
                DimensionRegionCache dimCache = ArgumentUtil.getDimCacheArgument(ctx);
                String regionName = (String)ctx.getArgument(CommandConstants.LOCAL.toString(), String.class);
                if (!dimCache.contains(regionName)) {
                    MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
                    throw ERROR_INVALID_VALUE.create((Object)regionName);
                }
                IMarkableRegion region = dimCache.getRegion(regionName);
                if (region != null) {
                    return region;
                }
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("No regions defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
                throw ERROR_INVALID_VALUE.create((Object)regionName);
            }
        }
        throw ERROR_INVALID_VALUE.create((Object)"");
    }

    public static IProtectedRegion getTargetRegion(CommandContext<class_2168> ctx, String argName) throws CommandSyntaxException {
        String regionName = (String)ctx.getArgument(argName, String.class);
        DimensionRegionCache dimCache = ArgumentUtil.getTargetDimRegionArgument(ctx);
        if (!dimCache.contains(regionName)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
            throw ERROR_INVALID_VALUE.create((Object)regionName);
        }
        IMarkableRegion region = dimCache.getRegion(regionName);
        if (region != null) {
            return region;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("No regions defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
        throw ERROR_INVALID_VALUE.create((Object)regionName);
    }

    public static RegionArgumentType region() {
        return new RegionArgumentType();
    }

    public static IMarkableRegion getRegionInPlayerDim(CommandContext<class_2168> ctx, String argName) throws CommandSyntaxException {
        String regionName = (String)ctx.getArgument(argName, String.class);
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        DimensionRegionCache dimCache = RegionDataManager.get().cacheFor((class_5321<class_1937>)player.method_37908().method_27983());
        IMarkableRegion region = dimCache.getRegion(regionName);
        if (region != null) {
            return region;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)("No regions defined in dim '" + String.valueOf(dimCache.dimensionKey().method_29177()) + "'")));
        throw ERROR_INVALID_VALUE.create((Object)regionName);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && String.valueOf(reader.peek()).matches(Pattern.compile("^[A-Za-z\\d\\-]$").pattern())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            boolean isValidName = s.matches(VALID_NAME_PATTERN.pattern());
            if (isValidName) {
                return s;
            }
            throw new IllegalArgumentException("Invalid region name supplied");
        }
        catch (IllegalArgumentException argumentException) {
            reader.setCursor(i);
            Constants.LOGGER.error("Error parsing region name");
            throw ERROR_AREA_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
        Object object = ctx.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            DimensionRegionCache dimCache = ArgumentUtil.getDimCacheArgument(ctx);
            return this.suggestRegionsForOwner(builder, src, dimCache);
        }
        return Suggestions.empty();
    }

    public <S> CompletableFuture<Suggestions> listSuggestionsIn(CommandContext<S> ctx, SuggestionsBuilder builder, class_1937 level) {
        Object object = ctx.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            Optional<DimensionRegionCache> dimensionCache = RegionManager.get().getDimensionCache((class_5321<class_1937>)level.method_27983());
            if (dimensionCache.isPresent()) {
                return this.suggestRegionsForOwner(builder, src, dimensionCache.get());
            }
            return Suggestions.empty();
        }
        return Suggestions.empty();
    }

    public CompletableFuture<Suggestions> suggestRegionsForOwner(SuggestionsBuilder builder, class_2168 src, DimensionRegionCache dimCache) {
        Collection regions = dimCache.getAllLocal();
        boolean hasPermission = Permissions.get().hasCmdPermission(src);
        if (hasPermission) {
            Collection<String> regionNames = dimCache.getRegionNames();
            if (regionNames.isEmpty()) {
                MessageSender.sendCmdFeedback(src, class_2561.method_43470((String)("No regions defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
                return Suggestions.empty();
            }
            return class_2172.method_9265(regionNames, (SuggestionsBuilder)builder);
        }
        class_1297 class_12972 = src.method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            Collection regionNames = (regions = (Collection)regions.stream().filter(region -> Permissions.get().hasOwnerPermission((IProtectedRegion)region, player)).collect(Collectors.toList())).stream().map(IProtectedRegion::getName).collect(Collectors.toSet());
            if (regionNames.isEmpty()) {
                MessageSender.sendCmdFeedback(src, class_2561.method_43470((String)("No regions defined in dim '" + dimCache.getDimensionalRegion().getName() + "'")));
                return Suggestions.empty();
            }
            return class_2172.method_9265((Iterable)regionNames, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public <S> CompletableFuture<Suggestions> listRegionsInTargetDim(CommandContext<S> ctx, SuggestionsBuilder builder) {
        Object object = ctx.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            try {
                DimensionRegionCache dimCache = ArgumentUtil.getTargetDimRegionArgument(ctx);
                return this.suggestRegionsForOwner(builder, src, dimCache);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
        }
        return Suggestions.empty();
    }
}

